;/*************************************************************************
; Program			:Test the internal ADC
; Description		:convert analog input signal to 8 bit digital output. 
;					:The digital signal will be send to serial port(RS232).
; Pin description	:Analog input pin = PA7-PA0
; CPU Control		:90S8535
; File name			:adc.asm
; Assembler			:AVR Studio 4.05
; 
;**************************************************************************

.include "8535def.inc"			
			.org   	$000 
    		rjmp  reset					;Reset Handle
			.org   	$00E          		;interrupt vector for ADC                  
             rjmp  ATOD 

;/************************
; Define Register
;/************************
.def		counter1  	= r16
.def		counter2	= r17
.def		counter3	= r18
.def		temp		= r19
.def		temp1		= r20
.def		data		= r21

;/*******************
; Main Program
;/*******************
reset:      ldi	temp,low(RAMEND)
            out	SPL,temp          	;init Stack Pointer     
            ldi	temp,high(RAMEND)
            out	SPH,temp        	
			sbi	UCR,TXEN
			sbi	UCR,RXEN
			ldi	temp,51				;baud rate = 9600
			out	UBRR,temp
MAIN:		ldi	ZH,high(2*ADCTB)
			ldi	ZL,low(2*ADCTB)
			rcall	Intro
;/**************************
; select channel by user
;/**************************
            rcall	RX_Byte
			rcall	TX_Byte
			ldi	temp,'1'
ADC_comp:	cp	data,temp
			breq	ADC1
			inc	temp
			cpi	temp,'9'
			breq	MAIN
			rjmp	ADC_comp

ADC1:		ser	temp
			out	PORTA,temp
			clr	temp
			out	DDRA,temp
			dec	data
			subi	data,$30
			out     ADMUX,data
			ldi	data,0x0a
			rcall	TX_Byte
			ldi	data,0x0d
			rcall	TX_Byte            	
			ldi temp,0b00011000    		;set sampling rate
            out ADCSR,temp 
            sbi ADCSR,ADEN         		;enable ADC
	    	sei
adcloop1:   sbi ADCSR,ADSC         		;start conversion 
			rjmp    adcloop1
  
;/************************************
; Interrupt service routine for ADC    			  
;/************************************
ATOD:       in      temp1,ADCL          ;read low byte
            in      data,ADCH           ;read high byte
			rcall 	ASCII
			rcall	delay200ms
            rcall	TX_Byte
			ldi	temp,2
			mov	data,temp1
			swap	data
ATOD1:		andi	data,0x0F
			rcall	ASCII
			rcall	TX_Byte
			mov	data,temp1
			dec	temp
			brne	ATOD1
			ldi	data,0x0D
			rcall	TX_Byte
			reti

ASCII:		cpi	data,$0A
			brlo	ASC_NUM
			subi	data,-$37
			ret
ASC_NUM:	subi	data,-$30
			ret            	               
;/*************************
; Send data to serial port
;/*************************
Intro:		lpm
			tst	r0
			breq	end_sub
TX232:		sbis	USR,UDRE
			rjmp	TX232
			out	UDR,r0
			adiw	ZL,1
			rjmp	Intro
end_sub:	ret		

TX_Byte:	sbis	USR,UDRE
			rjmp	TX_Byte
			out	UDR,data
			ret

RX_Byte:	sbis	USR,RXC
			rjmp	RX_Byte
			in	data,UDR
			ret
;/*****************
; delay time
;/*****************
delay1ms:	push	counter1
			push	counter2
			ldi	counter1,8
delay1ms_1: ldi counter2,250
delay1ms_2: nop
			dec counter2
            brne   	delay1ms_2
            dec    	counter1
            brne   	delay1ms_1
            pop	counter2
			pop	counter1
			ret          

delay200ms:	push	counter3
			ldi	counter3,200
delay200ms_1:	
			rcall	delay1ms
			dec	counter3
			brne	delay200ms_1
			pop	counter3
			ret

;/******************
; code segment
;/******************
ADCTB:		.db	0x0a,0x0d,"Test the 8 channel internal ADC.",0x0a,0x0d
			.db	"Please enter number 1 - 8 to test each ADC channel or ",0x0a,0x0d
			.db	"press the RESET button when you have to test the other channel. ",0x0a,0x0d      
			.db	"You select channel : ",0

           	 